% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writenii.R
\name{writeNIfTI2}
\alias{writeNIfTI2}
\alias{writenii}
\title{writeNIfTI with default non-reorientation}
\usage{
writeNIfTI2(nim, filename, dtype = FALSE, compression = 9, ...)

writenii(
  nim,
  filename,
  dtype = TRUE,
  drop_dim = TRUE,
  warn = FALSE,
  compression = 9,
  rm_extensions = TRUE,
  ...
)
}
\arguments{
\item{nim}{object of class \code{nifti}, passed to \code{\link[oro.nifti]{writeNIfTI}}}

\item{filename}{path to save the NIfTI file.  Suffix will be removed}

\item{dtype}{Should \code{\link{datatyper}} be run before writing?}

\item{compression}{compression level for gzipped files.}

\item{...}{Additional arguments passed to \code{\link[oro.nifti]{writeNIfTI}}}

\item{drop_dim}{Should \code{\link[oro.nifti]{drop_img_dim}} be run before writing?}

\item{warn}{Should warnings from \code{\link[oro.nifti]{writeNIfTI}} be 
printed?  If not, \code{\link{suppressWarnings}} is called}

\item{rm_extensions}{should niftiExtensions be converted to simple
nifti objects before writing?}
}
\value{
Nothing
}
\description{
This function calls the \code{\link[oro.nifti]{writeNIfTI}} function from the 
\code{oro.nifti} package, but makes sure to remove \code{.nii} extension and
warnings can be suppressed.
}
\note{
While \code{writeNIfTI2} does not run \code{\link{datatyper}} as default, 
\code{writenii} does.  Additional functionality will be added to \code{writenii} likely
but will not to \code{writeNIfTI2}
}
\examples{
set.seed(5)
dims = rep(10, 3)
arr = array(rnorm(prod(dims)), dim = dims)
nim = oro.nifti::nifti(arr)
rnifti = RNifti::asNifti(nim)
tfile = tempfile(fileext = ".nii.gz")
timg = writenii(nim, tfile, rm_extensions = TRUE, warn = TRUE)
timg = writeNIfTI2(nim, tfile, dtype = TRUE)
}
