% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_oaproc.R
\name{get_raindrop_trace}
\alias{get_raindrop_trace}
\title{Get Raindrop Trace}
\usage{
get_raindrop_trace(point, direction = "down")
}
\arguments{
\item{point}{sfc POINT including crs as created by:
\code{sf::st_sfc(sf::st_point(.. ,..), crs)}}

\item{direction}{character \code{"up"}, \code{"down"}, or \code{"none"}.
Controls the portion of the split flowline that is returned along with
the raindrop trace line.}
}
\value{
sf data.frame containing raindrop trace and requested
portion of flowline.
}
\description{
Uses a raindrop trace web service to trace the
nhdplus digital elevation model to the nearest downslop flowline.
}
\examples{
\donttest{
point <- sf::st_sfc(sf::st_point(x = c(-89.2158, 42.9561)), crs = 4326)

(trace <- get_raindrop_trace(point))

if(inherits(trace, "sf")) {
bbox <- sf::st_bbox(trace) + c(-0.005, -0.005, 0.005, 0.005)

nhdplusTools::plot_nhdplus(bbox = bbox, cache_data = FALSE)

plot(sf::st_transform(sf::st_sfc(point, crs = 4326), 3857), add = TRUE)
plot(sf::st_transform(sf::st_geometry(trace)[1], 3857), add = TRUE, col = "red")
plot(sf::st_transform(sf::st_geometry(trace)[2], 3857), add = TRUE, col = "black")
}
}

}
