% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Player.R
\name{get_player_game_log}
\alias{get_player_game_log}
\title{Get game-log by player, season, and game-type}
\usage{
get_player_game_log(
  player = 8480039,
  season = get_season_now()$seasonId,
  game_type = 2
)
}
\arguments{
\item{player}{integer Player ID}

\item{season}{integer in YYYYYYYY}

\item{game_type}{integer where 2=regular and 3=playoffs}
}
\value{
tibble with one row per game
}
\description{
\code{get_player_game_log()} retrieves information on each game for a given set of \code{player}, \code{season}, and \code{game_type}, including but not limited to their ID, date, and statistics. Access \code{get_players()} for \code{player} and \code{get_seasons()} for \code{season} references.
}
\examples{
playoff_Mikko_Rantanen_gl_20242025 <- get_player_game_log(
  player=8478420,
  season=20242025,
  game_type=3
)
}
