% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clean.R
\name{strip_situation_code}
\alias{strip_situation_code}
\title{Strip the situation code into goalie and skater counts, man differential,
and strength state for all the events (plays) in a play-by-play by
perspective}
\usage{
strip_situation_code(play_by_play)
}
\arguments{
\item{play_by_play}{data.frame of play-by-play(s); see \code{\link[=gc_play_by_play]{gc_play_by_play()}}
and/or \code{\link[=wsc_play_by_play]{wsc_play_by_play()}} for reference; must be untouched by
non-nhlscraper functions; saves time if \code{\link[=flag_is_home]{flag_is_home()}} has already been
called}
}
\value{
data.frame with one row per event (play) and added columns:
\code{homeIsEmptyNet}, \code{awayIsEmptyNet}, \code{homeSkaterCount}, \code{awaySkaterCount},
\code{isEmptyNetFor}, \code{isEmptyNetAgainst}, \code{skaterCountFor},
\code{skaterCountAgainst}, \code{manDifferential}, and \code{strengthState}
}
\description{
\code{strip_situation_code()} strip the situation code into goalie and skater
counts, man differential, and strength state for all the events (plays) in a
play-by-play by perspective.
}
\examples{
# May take >5s, so skip.
\donttest{
  test                         <- gc_play_by_play()
  test_is_home_flagged         <- flag_is_home(test)
  test_situation_code_stripped <- strip_situation_code(test_is_home_flagged)
}
}
