% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-invert_bijection.R
\name{inverse_with_uniroot}
\alias{inverse_with_uniroot}
\title{Numerically evaluate the inverse of a function at a specific point}
\usage{
inverse_with_uniroot(
  f = f,
  y,
  min_x = 0,
  max_x = 1,
  min_y = f(min_x),
  max_y = f(max_x)
)
}
\arguments{
\item{f}{(function) the function to be inverted; must be continuous
and increasing}

\item{y}{(scalar, double) the f(x)=y value in which to evaluate the inverse}

\item{min_x}{(scalar, double) the min of the domain of f()}

\item{max_x}{(scalar, double) the max of the domain of f()}

\item{min_y}{(scalar, double) the min in the range of f()}

\item{max_y}{(scalar, double) the max in the range of f()}
}
\value{
(scalar, double) vector of x=f^(-1)(y): the inverted value
}
\description{
Numerically evaluate the inverse of a function at a specific point
}
\examples{
inverse_with_uniroot(f = function(x) {
  2 * x
}, y = 0.5)
}
\keyword{internal}
