% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.unif.R
\name{overlap.unif}
\alias{overlap.unif}
\alias{overlap.sphere}
\title{Overlap calculation for uniform niche regions.}
\usage{
overlap.unif(muA, SigmaA, muB, SigmaB, alphaA = 0.95, alphaB = 0.95, nprob)

overlap.sphere(muA, sigmaA, muB, sigmaB, alphaA = 0.95, alphaB = 0.95)
}
\arguments{
\item{muA, muB}{Mean of niche regions.}

\item{SigmaA, SigmaB}{Variance matrix of elliptical niche regions.}

\item{alphaA, alphaB}{Probabilistic size of niche regions.}

\item{nprob}{Number of uniform draws from niche region \code{A}.}

\item{sigmaA, sigmaB}{standard deviations (scalars) of spherical niche regions.}
}
\value{
A Monte Carlo estimate of the niche overlap for \code{\link[=overlap.unif]{overlap.unif()}}, and an analytic calculation for \code{\link[=overlap.sphere]{overlap.sphere()}}.
}
\description{
Overlap calculation for uniform niche regions.
}
\details{
The overlap between niche regions \eqn{A} and \eqn{B} is defined as \eqn{vol(A \cap B)/vol(A \cup B)}, where the hypervolume of an \eqn{n}-dimensional region \eqn{S} is \eqn{vol(S) = \int_S dx}.  For elliptical niche regions, there are simple formulas for \eqn{vol(A)} and \eqn{vol(B)}.  Thus, we need only determine the volume of the intersection \eqn{vol(A \cap B)}, as the volume of the union is given by the formula \eqn{vol(A \cup B) = vol(A) + vol(B) - vol(A \cap B)}.

For spherical niche regions, \eqn{vol(A \cap B)} has a closed-form expression (see 'References').  For elliptical regions, no such formula exists and a Monte Carlo method is used instead.  That is, \eqn{vol(A \cap B)} is calculated by sampling uniformly from \eqn{A}, then multiplying \eqn{vol(A)} by the fraction of sampled points which fall into \eqn{B}.

While the uniform overlap metric is invariant to permutation of niche regions \eqn{A} and \eqn{B}, the accuracy of the Monte Carlo calculation of \eqn{vol(A \cap B)} is not: higher accuracy is obtained when a higher fraction of sampled points are in the opposite niche region.  \code{\link[=overlap.unif]{overlap.unif()}} does not attempt to determine for which region this is the case, though the choice can be informed by plotting the niche regions, e.g., with \code{\link[=niche.plot]{niche.plot()}}.
}
\examples{
# spherical case: compare Monte Carlo method to analytic formula

d <- 2 # 2D example
mA <- rnorm(d)
mB <- rnorm(d)
sigA <- rexp(1)
SigA <- sigA^2 * diag(d)
sigB <- rexp(1)
SigB <- sigB^2 * diag(d)

# plot circles
ellA <- ellipse(mA, SigA)
ellB <- ellipse(mB, SigB)
plot(0, type = "n",
     xlim = range(ellA[,1], ellB[,1]),
     ylim = range(ellA[,2], ellB[,2]), xlab = "x", ylab = "y")
lines(ellA, col = "red")
lines(ellB, col = "blue")
legend("topright", legend = c("niche A", "niche B"),
       fill = c("red", "blue"), bg = "white")

# compare niche calculations
overlap.sphere(mA, sigA, mB, sigB)
overlap.unif(mA, SigA, mB, SigB, nprob = 1e5)
}
\references{
Li, S. "Concise formulas for the area and volume of a hyperspherical cap." \emph{Asian Journal of Mathematics & Statistics} 4.1 (2011): 66-70. \doi{10.3923/ajms.2011.66.70}.
}
