% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBR2.R
\name{NBR2}
\alias{NBR2}
\title{NBR2 - Normalized Burn Ratio 2}
\usage{
NBR2(SWIR1, SWIR2)
}
\arguments{
\item{SWIR1}{A raster layer object with the reflectance values for the Short Wave Infrared 1 band.}

\item{SWIR2}{A raster layer object with the reflectance values for the Short Wave Infrared 2 band.}
}
\value{
NBR2 - Normalized Burn Ratio 2.
}
\description{
NBR2 modifies the Normalized Burn Ratio to highlight water sensitivity in vegetation and may be useful in post-fire recovery studies.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
bands <- stack(list.files(path_files,".tif", full.names=TRUE))
x <- ref_oli(bands, sun.elev= 67.97)
NBR2(x[[6]], x[[7]])

}
\references{
\url{https://www.usgs.gov/core-science-systems/nli/landsat/landsat-surface-reflectance-derived-spectral-indices}.
\url{https://www.geo.university/pages/spectral-indices-with-multispectral-satellite-data}.
}
