% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dExponentialGrowth.R
\name{dExponentialGrowth}
\alias{dExponentialGrowth}
\alias{rExponentialGrowth}
\title{Exponential Growth Model}
\usage{
dExponentialGrowth(x, a, b, r, log)

rExponentialGrowth(n, a, b, r)
}
\arguments{
\item{x}{vector of calendar years (in BP).}

\item{a}{lower (earliest) limit of the distribution (in BP).}

\item{b}{upper (latest) limit of the distribution (in BP).}

\item{r}{intrinsic growth rate.}

\item{log}{TRUE or 1 to return log probability. FALSE or 0 to return probability.}

\item{n}{number of random draws. Currently only n = 1 is supported, but the argument exists for standardization of "r" functions.}
}
\value{
For \code{dExponentialGrowth}: the probability (or likelihood) or log probability of an observed date x (in Cal BP). For \code{rExponentialGrowth} a simulated date in Cal BP.
}
\description{
Density and random generation of an exponential growth model distribution.
}
\examples{
p = list(r=0.002)
modelPlot(model = dExponentialGrowth,a=6000,b=4000,params=p,alpha = 1)
}
\author{
Enrico Crema
}
