% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npde.R
\name{addNpde}
\alias{addNpde}
\title{NPDE calculation for nlmixr}
\usage{
addNpde(
  object,
  nsim = 300,
  ties = TRUE,
  seed = 1009,
  updateObject = TRUE,
  cholSEtol = (.Machine$double.eps)^(1/3),
  ...
)
}
\arguments{
\item{object}{nlmixr fit object}

\item{nsim}{Number of simulations.  By default this is 300}

\item{ties}{When TRUE, the npde distribution can have ties.  When
FALSE, the npde distribution uses uniform random numbers to
prevent ties.}

\item{seed}{Seed for running nlmixr simulation.  By default 1009}

\item{updateObject}{Boolean indicating if original object should be updated.  By default this is TRUE.}

\item{cholSEtol}{tolerance for Generalized Cholesky
Decomposition.  Defaults to suggested (.Machine$double.eps)^(1/3)}

\item{...}{Other ignored parameters.}
}
\value{
New nlmixr fit object
}
\description{
NPDE calculation for nlmixr
}
\author{
Matthew L. Fidler
}
