% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/nlmixrGrad.R
\name{nlmixrEval_}
\alias{nlmixrEval_}
\alias{nlmixrGrad_}
\alias{nlmixrParHist_}
\alias{nlmixrGradFun}
\title{Create a gradient function based on gill numerical differences}
\usage{
nlmixrEval_(theta, md5)

nlmixrGrad_(theta, md5)

nlmixrParHist_(md5)

nlmixrGradFun(
  what,
  envir = parent.frame(),
  which,
  thetaNames,
  gillRtol = sqrt(.Machine$double.eps),
  gillK = 10L,
  gillStep = 2,
  gillFtol = 0,
  useColor = crayon::has_color(),
  printNcol = floor((getOption("width") - 23)/12),
  print = 1
)
}
\arguments{
\item{theta}{for the internal functions theta is the parameter
values}

\item{md5}{the md5 identifier for the internal gradient function
information.}

\item{what}{either a function or a non-empty character string naming the
    function to be called.}

\item{envir}{an environment within which to evaluate the call.  This
    will be most useful if \code{what} is a character string and
    the arguments are symbols or quoted expressions.}

\item{which}{Which parameters to calculate the forward difference
and optimal forward difference interval}

\item{thetaNames}{Names for the theta parameters}

\item{gillRtol}{The relative tolerance used for Gill 1983
determination of optimal step size.}

\item{gillK}{The total number of possible steps to determine the
optimal forward/central difference step size per parameter (by
the Gill 1983 method).  If 0, no optimal step size is
determined.  Otherwise this is the optimal step size
determined.}

\item{gillStep}{When looking for the optimal forward difference
step size, this is This is the step size to increase the
initial estimate by.  So each iteration the new step size =
(prior step size)*gillStep}

\item{gillFtol}{The gillFtol is the gradient error tolerance that
is accepable before issuing a warning/error about the gradient estimates.}

\item{useColor}{Boolean indicating if focei can use ASCII color codes}

\item{printNcol}{Number of columns to printout before wrapping
parameter estimates/gradient}

\item{print}{Integer representing when the outer step is
printed. When this is 0 or do not print the iterations.  1 is
print every function evaluation (default), 5 is print every 5
evaluations.}
}
\description{
Create a gradient function based on gill numerical differences
}
\examples{

func0 <- function(x){ sum(sin(x))  }

## This will printout every interation or when print=X
gf <- nlmixrGradFun(func0)

## x
x <- (0:10)*2*pi/10;
gf$eval(x)
gf$grad(x)

## x2
x2 <- x+0.1
gf$eval(x2)
gf$grad(x2)

## Gives the parameter history as a data frame
gf$hist()

}
