% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocovar.R
\name{addCovVar}
\alias{addCovVar}
\title{Adding covariate to a given variable in an nlmixr2 model expression}
\usage{
addCovVar(
  fitobject,
  varName,
  covariate,
  norm = c("median", "mean", "autoscale"),
  norm_type = c("mul", "div", "sub", "add", "autoscale"),
  categorical = FALSE,
  isHS = FALSE,
  initialEst = 0,
  initialEstLB = -Inf,
  initialEstUB = Inf
)
}
\arguments{
\item{fitobject}{an nlmixr2 'fit' object}

\item{varName}{a string giving the variable name to which covariate needs to be added}

\item{covariate}{a string giving the covariate name; must be present in the data used for 'fit'}

\item{norm}{the kind of normalization to be used while normalizing covariates; must be either 'mean' or 'median'}

\item{norm_type}{a string defining operator to be used for transforming covariates using 'norm'; must be one among 'mul', 'div', 'sub', 'add'}

\item{categorical}{a boolean indicating if the 'covariate' is categorical}

\item{isHS}{a boolean indicating if 'covariate' is of Hockey-stick kind}

\item{initialEst}{the initial estimate for the covariate parameters to be estimated; default is 0}

\item{initialEstLB}{a lower bound for the covariate parameters to be estimated; default is -Inf}

\item{initialEstUB}{an upper bound for the covariate parameters to be estimated; default is Inf}
}
\value{
a list with the updated model expression and data with columns corresponding to normalized covariate(s) appended
}
\description{
Adding covariate to a given variable in an nlmixr2 model expression
}
\author{
Vipul Mann, Matthew Fidler
}
