% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computingutil.R
\name{foldgen}
\alias{foldgen}
\title{Stratified cross-validation fold generator function, inspired from the caret}
\usage{
foldgen(data, nfold = 5, stratVar = NULL)
}
\arguments{
\item{data}{data frame used in the analysis}

\item{nfold}{number of k-fold cross validations. Default is 5}

\item{stratVar}{Stratification Variable. Default is NULL and ID is used for CV}
}
\value{
return data.frame with the fold column attached
}
\description{
Stratified cross-validation fold generator function, inspired from the caret
}
\examples{
d <- nlmixr2data::theo_sd
d$SEX <-0
d$SEX[d$ID<=6] <-1

covarsVec <- c("WT")

# Stratified cross-validation data with CMT
df1 <- foldgen(d, nfold=5, stratVar="CMT")

# Stratified cross-validation data with ID (individual)
df2 <- foldgen(d, nfold=5, stratVar=NULL)
}
\author{
Vishal Sarsani, caret
}
