% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCSM.mxModel_helper.R
\name{getLCSM.mxModel}
\alias{getLCSM.mxModel}
\title{Construct An Object of mxModel for Latent Change Score Model with Time-invariant Covariates (If Any) To Be
Evaluated}
\usage{
getLCSM.mxModel(
  dat,
  t_var,
  y_var,
  curveFun,
  intrinsic,
  records,
  growth_TIC,
  starts
)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables with
repeated measurements and occasions, and time-invariant covariates (TICs) if any. It takes the value passed from \code{getLCSM()}.}

\item{t_var}{A string specifying the prefix of the column names corresponding to the time variable at each study wave.
It takes the value passed from \code{getLCSM()}.}

\item{y_var}{A string specifying the prefix of the column names corresponding to the outcome variable at each study wave.
It takes the value passed from \code{getLCSM()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for latent change score
models include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"} (or \code{"EXP"}), \code{"Jenss-Bayley"}
(or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the value passed from \code{getLCSM()}.}

\item{intrinsic}{A logical flag indicating whether to build an intrinsically nonlinear longitudinal model. It takes the value
passed from \code{getLCSM()}.}

\item{records}{A numeric vector specifying indices of the study waves. It takes the value passed from \code{getLCSM()}.}

\item{growth_TIC}{A string or character vector specifying the column name(s) of time-invariant covariate(s) contributing to the
variability of growth factors if any. It takes the value passed from \code{getLCSM()}.}

\item{starts}{A list of initial values for the parameters, either takes the value passed from \code{getLCSM()} or
derived by the helper function \code{getUNI.initial()}.}
}
\value{
A pre-optimized mxModel for a Latent Change Score Model.
}
\description{
This function builds up an object of mxModel for a Latent Change Score Model with user-specified
functional form (including whether intrinsically nonlinear) with time-invariant covariates (if any).
}
\keyword{internal}
