% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_nn_search.R
\name{corr_nn}
\alias{corr_nn}
\title{Find ordered nearest neighbors based on correlation, assuming the
absolute value of the correlation is monotonically decreasing with distance.
Returns an n X (m + 1) matrix, each row indicating the m + 1 nearest
neighbors including itself.}
\usage{
corr_nn(covmat, m)
}
\arguments{
\item{covmat}{the covariance matrix}

\item{m}{the number of nearest neighbors}
}
\value{
an n X (m + 1) matrix
}
\description{
Find ordered nearest neighbors based on correlation, assuming the
absolute value of the correlation is monotonically decreasing with distance.
Returns an n X (m + 1) matrix, each row indicating the m + 1 nearest
neighbors including itself.
}
\examples{
library(RANN)
library(nntmvn)
set.seed(123)
d <- 3
n <- 100
locs <- matrix(runif(d * n), n, d)
covparms <- c(2, 0.01, 0)
covmat <- GpGp::matern15_isotropic(covparms, locs)
m <- 10
NNarray_test <- RANN::nn2(locs, k = m + 1)[[1]]
NNarray <- nntmvn::corr_nn(covmat, m)
cat("Number of mismatch is", sum(NNarray != NNarray_test, na.rm = TRUE))

}
