% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-code.R
\name{get_code}
\alias{get_code}
\title{Get the codes of geographical levels}
\usage{
get_code(
  type = c("fylke", "kommune", "bydel", "grunnkrets"),
  from = NULL,
  to = NULL,
  date = FALSE,
  names = TRUE
)
}
\arguments{
\item{type}{Type of regional granularity ie. fylke, kommune etc.}

\item{from}{Specify the starting year for range period. Current year is the
default.}

\item{to}{Specify the year to end the range period. Current year is used when
not specified.}

\item{date}{Give complete date if TRUE else year only. Default it FALSE}

\item{names}{Include names. Default is TRUE}
}
\value{
A dataset of class \code{data.table} consisting codes of selected
geographical level and the duration the codes are valid ie. from and to.
}
\description{
This function will download the codes of selected geographical levels via API.
}
\examples{
\dontrun{
mydata <- get_code("kommune", from = 2017, to = 2020)
}
}
