% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample_dat_scale.R
\name{resample_dat_scale_naretainer}
\alias{resample_dat_scale_naretainer}
\title{Title: A function to create an attribute or column for each sample loaded into the microplate wells.}
\usage{
resample_dat_scale_naretainer(df, tnp, cycles)
}
\arguments{
\item{df}{A clean data frame with attributes or tuples containing a mixture of samples.}

\item{tnp}{A numeric value indicating the number of rows used. TNP is used as an acronym for Test, Negative, Positive.}

\item{cycles}{A numeric value indicating the number of cycles selected by the user when running the FLUOstar instrument.}
}
\value{
A new data frame where separated samples are assigned a separate attribute or column.
}
\description{
Creates a data frame where each sample loaded into the microplate wells has a separate attribute.
NA values are retained for more control.
}
\note{
This function builds on or scales-up  @seealso \code{\link[=resample_dat]{resample_dat()}}, hence the suffix scale.
This function is less optimized than @seealso \code{\link[=resample_dat_scale_optimus]{resample_dat_scale_optimus()}}.
}
\examples{
fpath <- system.file("extdata", "dat_4.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
resampled_scaled <- resample_dat_scale_naretainer(nocomma_dat, tnp=3, cycles=40)
}
\seealso{
\code{\link[=resample_dat]{resample_dat()}}
}
\author{
Tingwei Adeck
}
