% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_separate.R
\name{nest_separate}
\alias{nest_separate}
\title{Separate a character column into multiple columns in a column of nested data frames}
\usage{
nest_separate(
  .data,
  .nest_data,
  col,
  into,
  sep = "[^[:alnum:]]+",
  remove = TRUE,
  convert = FALSE,
  extra = "warn",
  fill = "warn",
  ...
)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{col}{Column name or position within. Must be present in all data frames
in \code{.nest_data}. This is passed to \code{\link[tidyselect:vars_pull]{tidyselect::vars_pull()}}.

This argument is passed by expression and supports quasiquotation (you can
unquote column names or column positions).}

\item{into}{Names of new variables to create as character vector.
Use \code{NA} to omit the variable in the output.}

\item{sep}{Separator between columns.

If character, \code{sep} is interpreted as a regular expression. The default
value is a regular expression that matches any sequence of
non-alphanumeric values.

If numeric, \code{sep} is interpreted as character positions to split at. Positive
values start at 1 at the far-left of the string; negative value start at -1 at
the far-right of the string. The length of \code{sep} should be one less than
\code{into}.}

\item{remove}{If \code{TRUE}, remove input column from output data frame.}

\item{convert}{If \code{TRUE}, will run \code{\link[=type.convert]{type.convert()}} with
\code{as.is = TRUE} on new columns. This is useful if the component
columns are integer, numeric or logical.

NB: this will cause string \code{"NA"}s to be converted to \code{NA}s.}

\item{extra}{If \code{sep} is a character vector, this controls what
happens when there are too many pieces. There are three valid options:
\itemize{
\item \code{"warn"} (the default): emit a warning and drop extra values.
\item \code{"drop"}: drop any extra values without a warning.
\item \code{"merge"}: only splits at most \code{length(into)} times
}}

\item{fill}{If \code{sep} is a character vector, this controls what
happens when there are not enough pieces. There are three valid options:
\itemize{
\item \code{"warn"} (the default): emit a warning and fill from the right
\item \code{"right"}: fill with missing values on the right
\item \code{"left"}: fill with missing values on the left
}}

\item{...}{Additional arguments passed on to \code{\link[tidyr:separate]{tidyr::separate()}} methods.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will have the specified column split according to the regular expression or
the vector of character positions.
}
\description{
\code{nest_separate()} is used to separate a single character column into multiple
columns using a regular expression or a vector of character positions in a
list of nested data frames.
}
\details{
\code{nest_separate()} is a wrapper for \code{\link[tidyr:separate]{tidyr::separate()}} and maintains the functionality
of \code{separate()} within each nested data frame. For more information on \code{separate()}
please refer to the documentation in \href{https://tidyr.tidyverse.org/}{'tidyr'}.
}
\examples{
set.seed(123)
gm <- gapminder::gapminder \%>\% mutate(comb = paste(continent,year,sep = "-"))
gm_nest <- gm \%>\% tidyr::nest(country_data = -continent)

gm_nest \%>\% 
  nest_separate(.nest_data = country_data,
                col = comb,
                into = c("var1","var2"),
                sep = "-")
}
\seealso{
Other tidyr verbs: 
\code{\link{nest_drop_na}()},
\code{\link{nest_extract}()},
\code{\link{nest_fill}()},
\code{\link{nest_replace_na}()},
\code{\link{nest_unite}()}
}
\concept{tidyr verbs}
