% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGenoDefinedParentGenotypes.R
\name{getGenoDefinedParentGenotypes}
\alias{getGenoDefinedParentGenotypes}
\title{Assigns parental genotype contributions to an IDs genotype by attributing
alleles to sire or dam}
\usage{
getGenoDefinedParentGenotypes(alleles, genotype, id, sire, dam, n)
}
\arguments{
\item{alleles}{data.frame \code{id, parent, V1 ... Vn}
A data.frame providing the maternal and paternal alleles for an animal
for each iteration. The first two columns provide the animal's ID and
whether the allele came from the sire or dam. These are followed by
\code{n} columns indicating the allele for that iteration.}

\item{genotype}{A dataframe containing known genotypes. It has three
columns:  \code{id}, \code{first}, and \code{second}. The second and third
columns contain the integers indicating the observed genotypes.}

\item{id}{A character vector of length one having the ID of interest}

\item{sire}{character vector with unique identifier for an
individual's father (\code{NA} if unknown).}

\item{dam}{character vector with unique identifier for an
individual's mother (\code{NA} if unknown).}

\item{n}{integer indicating the number of iterations to simulate.}
}
\value{
data.frame \code{id, parent, V1 ... Vn}
A data.frame providing the maternal and paternal alleles for an animal
for each iteration. The first two columns provide the animal's ID and
whether the allele came from the sire or dam. These are followed by
\code{n} columns indicating the allele for that iteration.

This is not correct for situations where one haplotype is not known.
}
\description{
Assigns parental genotype contributions to an IDs genotype by attributing
alleles to sire or dam
}
