% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svarmod.sb.R
\name{disc.sb}
\alias{disc.sb}
\title{Discretization nodes of a Shapiro-Botha variogram model}
\usage{
disc.sb(nx, dk = 0, rmax = 1)
}
\arguments{
\item{nx}{number of discretization nodes.}

\item{dk}{dimension of the kappa function (\code{dk >= 1}, see Details below).}

\item{rmax}{maximum lag considered.}
}
\description{
Computes the discretization nodes of a `nonparametric' extended Shapiro-Botha 
variogram model, following Gorsich and Genton (2004), as the scaled roots of 
Bessel functions.
}
\details{
If \code{dk >= 1}, the nodes are computed as: 
\deqn{x_i = q_i/rmax; i = 1,\ldots, nx,} where 
\eqn{q_i} are the first \eqn{n} roots of \eqn{J_{(d-2)/2}}, \eqn{J_p} 
is the Bessel function of order \eqn{p} and \eqn{rmax} 
is the maximum lag considered. The computation of the zeros of the Bessel  
function is done using the efficient algorithm developed by Ball (2000).

If \code{dk == 0} (corresponding to a model valid in any spatial dimension), 
the nodes are computed so the gaussian variogram models involved have
practical ranges: 
   \deqn{r_i = 2 ( 1 + (i-1) ) rmax/nx; i = 1,\ldots, nx.}
}
\examples{
disc.sb( 12, 1, 1.0)

nx <- 1
dk <- 0
x <- disc.sb(nx, dk, 1.0)
h <- seq(0, 1, length = 100)
plot(h, kappasb(x * h, 0), type="l", ylim = c(0, 1))
abline(h = 0.05, lty = 2)
}
\references{
Ball, J.S. (2000) Automatic computation of zeros of Bessel functions and other
  special functions. \emph{SIAM Journal on Scientific Computing}, \bold{21}, 
  1458-1464.  

Gorsich, D.J. and Genton, M.G. (2004) On the discretization of nonparametric 
  covariogram estimators. \emph{Statistics and Computing}, \bold{14}, 99-108.
}
\seealso{
\code{\link{kappasb}}, \code{\link{fitsvar.sb.iso}}.
}

