% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAnnotations.R
\name{getAnnotations}
\alias{getAnnotations}
\title{Gets the annotations on the given layer of the given transcript.}
\usage{
getAnnotations(labbcat.url, id, layerId, pageLength = NULL, pageNumber = NULL)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{A transcript ID (i.e. transcript name)}

\item{layerId}{A layer ID}

\item{pageLength}{The maximum number of annotations to return, or null to return all}

\item{pageNumber}{The zero-based page number to return, or null to return the first page}
}
\value{
A named list of annotations, with members:
\itemize{
 \item{\emph{id} The annotation's unique ID}
 \item{\emph{layerId} The name of the layer it comes from}
 \item{\emph{label} The value of the annotation}
 \item{\emph{startId} The ID of the start anchor},
 \item{\emph{endId} The ID of the end anchor},
 \item{\emph{parentId} The ID of the parent annotation},
 \item{\emph{ordinal} The ordinal of the annotation among its peers},
 \item{\emph{confidence} A rating from 0-100 of the confidence of the label
 e.g. 10: default value, 50: automatically generated, 100: manually annotated}
}
}
\description{
Returns the annotations on the given layer of the given transcript.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get all the orthography tokens in UC427_ViktoriaPapp_A_ENG.eaf
orthography <- getAnnotations(labbcat.url, "UC427_ViktoriaPapp_A_ENG.eaf", "orthography")

## Get the first 20 orthography tokens in UC427_ViktoriaPapp_A_ENG.eaf
orthography <- getAnnotations(labbcat.url, "UC427_ViktoriaPapp_A_ENG.eaf", "orthography", 20, 0)
}

}
\seealso{
\code{\link{getTranscriptIds}}
  \code{\link{getTranscriptIdsInCorpus}}
  \code{\link{getTranscriptIdsWithParticipant}}
  \code{\link{countAnnotations}}
}
\keyword{transcript}
