% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDictionaryEntry.R
\name{addDictionaryEntry}
\alias{addDictionaryEntry}
\title{Adds an entry to a dictionary.}
\usage{
addDictionaryEntry(labbcat.url, manager.id, dictionary.id, key, entry)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{manager.id}{The layer manager ID of the dictionary, as returned by getDictionaries}

\item{dictionary.id}{The ID of the dictionary, as returned by getDictionaries}

\item{key}{The key (word) in the dictionary to add an entry for.}

\item{entry}{The value (definition) for the given key.}
}
\value{
NULL if the entry was added, or a list of error messages if not.
}
\description{
This function creates adds a new entry to the given dictionary.
}
\details{
You must have edit privileges in LaBB-CAT in order to be able to use this function.
}
\examples{
\dontrun{
## Add the word "robert" to the CELEX wordform pronunciation dictionary
addDictionaryEntry(labbcat.url, "CELEX-EN", "Phonology (wordform)", "robert", "'rQ-b@t")
}

}
\seealso{
\link{getDictionaries}

\link{getDictionaryEntries}
}
\keyword{annotation}
\keyword{layer}
