% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParticipantAttributes.R
\name{getParticipantAttributes}
\alias{getParticipantAttributes}
\title{Gets participant attribute values for given participant IDs.}
\usage{
getParticipantAttributes(labbcat.url, participant.ids, layer.ids)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{participant.ids}{A vector of participant IDs}

\item{layer.ids}{A vector of layer IDs corresponding to participant attributes. In
general, these are layers whose ID is prefixed 'participant_', however formally it's
any layer where layer$parentId == 'participant' && layer$alignment == 0.}
}
\value{
A data frame of attribute value labels.
}
\description{
Gets participant attribute values for given participant IDs.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get gender and age for all participants
attributes <- getParticipantAttributes(labbcat.url,
            getParticipantIds(labbcat.url),
            c('participant_gender', 'participant_age'))

}

}
\keyword{annotation}
\keyword{label}
\keyword{layer}
