% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressionFromIds.R
\name{expressionFromIds}
\alias{expressionFromIds}
\title{Generates a query expression for matching transcripts or participants by ID, for use with
\link{getMatches}}
\usage{
expressionFromIds(ids, not = FALSE)
}
\arguments{
\item{ids}{A list of IDs.}

\item{not}{Whether to match the given IDs (FALSE), or everything \emph{except} the
given IDs.}
}
\value{
A query expression which can be passed as the
transcript.expression or participant.expression parameter of \link{getMatches}
or the expression parameter of \link{getMatchingTranscriptIds} or
\link{getMatchingParticipantIds}
}
\description{
This function generates a query expression fragment which can be passed as
the transcript.expression or participant.expression parameter of \link{getMatches},
using a list of corresponding IDs.
}
\examples{
\dontrun{
## Perform a search
transcript.ids <- c("AP511_MikeThorpe.eaf", "BR2044_OllyOhlson.eaf")
results <- getMatches(labbcat.url, list(segment="I"),
                      transcript.expression = expressionFromIds(transcript.ids))
}
}
\seealso{
\link{expressionFromAttributeValue}

\link{expressionFromAttributeValues}

\link{expressionFromTranscriptTypes}

\link{getMatches}
}
\keyword{search}
