% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveParticipant.R
\name{saveParticipant}
\alias{saveParticipant}
\title{Saves information about a single participant}
\usage{
saveParticipant(labbcat.url, id, label = id, attributes = NULL)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{The participant ID - either the unique internal database ID, or their name.}

\item{label}{The new ID (name) for the participant}

\item{attributes}{A named list of participant attribute values - the names are the
participant attribute layer IDs, and the values are the corresponding new attribute
values. The pass phrase for participant access can also be set by specifying a "_password"
attribute.}
}
\value{
TRUE if the participant's record was updated, FALSE if there were no changes detected.
}
\description{
This function allows the participant attributes and the ID of a given participant to be
updated.
}
\details{
To change the ID of an existing participant, pass the old/current ID as the \code{id},
and pass the new ID as the \code{label}.

If the participant ID does not already exist in the database, a new participant record
is created.
}
\examples{
\dontrun{
## Create a new participant record
saveParticipant(labbcat.url, "Juan Perez", attributes=list(participant_gender="M"))

## Change the name and the gender of the participant record
saveParticipant(labbcat.url, "Juan Perez", "Maria Perez", list(participant_gender="F"))

### Delete the participant we just created
deleteParticipant(labbcat.url, "Maria Perez")
}

}
\seealso{
\itemize{
\item \link{getParticipant}
\item \link{deleteParticipant}
}
}
\keyword{participant}
