% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcriptUploadDelete.R
\name{transcriptUploadDelete}
\alias{transcriptUploadDelete}
\title{Cancel a transcript upload started by a previous call to transcriptUpload().}
\usage{
transcriptUploadDelete(labbcat.url, id)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{Upload ID returned by the prior call to transcriptUpload().}
}
\description{
This cancels a transcript upload started by a previous call to transcriptUpload()
deleting any uploaded files from the server.
}
\examples{
\dontrun{
## Get attributes for new transcript
corpus <- getCorpusIds(labbcat.url)[1]
transcript.type.layer <- getLayer(labbcat.url, "transcript_type")
transcript.type <- transcript.type.layer$validLabels[[1]]

## upload transcript and its media
result <- transcriptUpload(labbcat.url, "my-transcript.eaf", "my-transcript.wav", FALSE)

## Changed our mind, cancel this upload
transcriptUploadDelete(labbcat.url, result$id)
}
}
\seealso{
\itemize{
\item \link{transcriptUpload}
\item \link{transcriptUploadParameters}
\item \link{newTranscript}
\item \link{updateTranscript}
}
}
\keyword{management}
\keyword{transcript}
