% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_payouts.R
\name{calculate_payouts}
\alias{calculate_payouts}
\title{Calculate payouts}
\usage{
calculate_payouts(
  entropy,
  pay_obs,
  pay_dm,
  pay_no_guess,
  deterministic = FALSE
)
}
\arguments{
\item{entropy}{A list containing the entropy}

\item{pay_obs}{A numeric with pay to the observer for guessing correctly}

\item{pay_dm}{A numeric with pay to the decision maker if the observer does 
not guess}

\item{pay_no_guess}{A numeric with pay to the observer for not guessing}

\item{deterministic}{If TRUE a deterministic procedure is used to determine 
whether the observer tries to guess. Default is FALSE and the probability is
calculated using a logit expression}
}
\value{
A list or list of lists where each list contains the payout to the 
observer and decision maker.
}
\description{
The function is a wrapper function for \code{\link{calc_payout_obs}} and
\code{\link{calc_payout_dm}}, and exported to be used by the user. 
It calculates the expected payout to both 
observers and decision makers for each possible action undertaken by the 
decision maker, and the observers choice of whether or not to try and guess
the rule.
}
