% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{as.adp}
\alias{as.adp}
\title{Create an adp Object}
\usage{
as.adp(time, distance, v, a = NULL, q = NULL, orientation = "upward",
  coordinate = "enu")
}
\arguments{
\item{time}{of observations in POSIXct format}

\item{distance}{to centre of bins}

\item{v}{array of velocities, with first index for time, second for bin number, and third for beam number}

\item{a}{amplitude, a \code{\link{raw}} array with dimensions matching \code{u}}

\item{q}{quality, a \code{\link{raw}} array with dimensions matching \code{u}}

\item{orientation}{a string indicating sensor orientation, e.g. \code{"upward"} and \code{"downward"}}

\item{coordinate}{a string indicating the coordinate system, \code{"enu"}, \code{"beam"}, \code{"xy"}, or \code{"other"}}
}
\value{
An object of \code{\link{adp-class}}.
}
\description{
Create an adp Object
}
\details{
Construct an object of \code{\link{adp-class}}.  Only a basic
subset of the typical \code{data} slot is represented in the arguments
to this function, on the assumption that typical usage in reading data
is to set up a nearly-blank \code{\link{adp-class}} object, the \code{data}
slot of which is then inserted.  However, in some testing situations it
can be useful to set up artificial \code{adp} objects, so the other
arguments may be useful.

A few defaults are set for some
}
\examples{
data(adp)
t <- adp[["time"]]
d <- adp[["distance"]]
v <- adp[["v"]]
a <- as.adp(time=t, distance=d, v=v)
\dontrun{
plot(a)
}
}

