% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odf.R
\docType{class}
\name{odf-class}
\alias{odf-class}
\title{Class to Store ODF data}
\description{
Class for data stored in a format used at Canadian Department of Fisheries
and Oceans laboratories. This is somewhat unusual amongst \code{oce}
classes, in that it does not map to a particular instrument, but rather to a
storage type; in that sense, it is similar to the \code{bremen-class}.
}
\section{Methods}{


Consider an ODF object named \code{odf}.

\emph{Accessing metadata.}

Metadata (contained in the S4 slot named \code{metadata}) may be retrieved
or set by name, \code{odf[["longitude"]] <- odf[["longitude"]] + 1} corrects
a one-degree error.

\emph{Accessing measured data.}

Column data may be accessed by name, e.g. \code{odf[["salinity"]]},
\code{odf[["temperature"]]}, \code{odf[["pressure"]]}, etc.  It is up to the
user to realize what is in the object.

\emph{Assigning values.}

Items stored in the object may be altered with e.g.  \code{odf[["salinity"]]
<- rep(35,10)}.

\emph{Overview of contents.}

The \code{show} method (e.g.  \code{show(odf)}) displays information about
the object.
}
\author{
Dan Kelley
}
\seealso{
Other classes provided by \code{oce}: \code{\link{adp-class}},
  \code{\link{adv-class}}, \code{\link{argo-class}},
  \code{\link{bremen-class}}, \code{\link{cm-class}},
  \code{\link{coastline-class}}, \code{\link{ctd-class}},
  \code{\link{echosounder-class}},
  \code{\link{lisst-class}}, \code{\link{lobo-class}},
  \code{\link{met-class}}, \code{\link{oce-class}},
  \code{\link{rsk-class}}, \code{\link{sealevel-class}},
  \code{\link{section-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}

Other things related to \code{odf} data: \code{\link{ODF2oce}},
  \code{\link{[[,odf-method}},
  \code{\link{[[<-,odf-method}},
  \code{\link{plot,odf-method}},
  \code{\link{subset,odf-method}},
  \code{\link{summary,odf-method}}
}

