% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.R
\docType{methods}
\name{subset,met-method}
\alias{subset,met-method}
\title{Subset a Met Object}
\usage{
\S4method{subset}{met}(x, subset, ...)
}
\arguments{
\item{x}{An object inheriting from \code{\link{met-class}}.}

\item{subset}{An expression indicating how to subset \code{x}.}

\item{\dots}{ignored.}
}
\value{
A new \code{met} object.
}
\description{
This function is somewhat analogous to \code{\link{subset.data.frame}}.
}
\examples{
library(oce)
data(met)
# Few days surrounding Hurricane Juan
plot(subset(met, time > as.POSIXct("2003-09-27", tz="UTC")))

}
\author{
Dan Kelley
}
\seealso{
Other things related to \code{met} data: \code{\link{[[,met-method}},
  \code{\link{[[<-,met-method}}, \code{\link{as.met}},
  \code{\link{met-class}}, \code{\link{met}},
  \code{\link{plot,met-method}}, \code{\link{read.met}},
  \code{\link{summary,met-method}}
}

