% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{methods}
\name{summary,oce-method}
\alias{summary,oce-method}
\title{Summarize an oce Object}
\usage{
\S4method{summary}{oce}(object, ...)
}
\arguments{
\item{object}{The object to be summarized.}

\item{...}{Extra arguments (ignored)}
}
\description{
Provide a textual summary of some pertinent aspects of the object, including
selected components of its \code{metadata} slot, statistical and
dimensional information on the entries in the \code{data} slot,
and a listing of the contents of its \code{processingLog} slot.
The details depend on the class of the object, especially for
the \code{metadata} slot, so it can help to consult the specialized
documentation, e.g. \code{\link{summary,ctd-method}} for CTD objects
(i.e. objects inheriting from \code{\link{ctd-class}}.)
It is important to note that this is not
a good way to learn the details of the object contents. Instead,
for an object named \code{object}, say, one might use \code{\link{str}(object)}
to learn about all the contents, or \code{\link{str}(object[["metadata"]])}
to learn about the \code{metadata}, etc.
}
\examples{
o <- new("oce")
summary(o)
}

