% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{binMean1D}
\alias{binMean1D}
\title{Bin-average f=f(x)}
\usage{
binMean1D(x, f, xbreaks)
}
\arguments{
\item{x}{Vector of numerical values.}

\item{f}{Vector of numerical values.}

\item{xbreaks}{Vector of values of x at the boundaries between bins, calculated using
\code{\link{pretty}} if not supplied.}
}
\value{
A list with the following elements: the breaks (\code{xbreaks},
midpoints (\code{xmids}) between those breaks,
the count (\code{number}) of \code{x} values between successive breaks,
and the resultant average (\code{result}) of \code{f}, classified by the
\code{x} breaks.
}
\description{
Average the values of a vector \code{f} in bins defined on another
vector \code{x}. A common example might be averaging CTD profile
data into pressure bins (see \dQuote{Examples}).
}
\examples{
library(oce)
data(ctd)
z <- ctd[["z"]]
T <- ctd[["temperature"]]
plot(T, z)
TT <- binMean1D(z, T, seq(-100, 0, 1))
lines(TT$result, TT$xmids, col='red')

}
\seealso{
Other bin-related functions: \code{\link{binApply1D}},
  \code{\link{binApply2D}}, \code{\link{binAverage}},
  \code{\link{binCount1D}}, \code{\link{binCount2D}},
  \code{\link{binMean2D}}
}
\author{
Dan Kelley
}
