% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapLongitudeLatitudeXY}
\alias{mapLongitudeLatitudeXY}
\title{Convert From Longitude and Latitude to X and Y}
\usage{
mapLongitudeLatitudeXY(longitude, latitude)
}
\arguments{
\item{longitude}{vector of the longitudes of points, or an object from which
both latitude and longitude can be inferred (e.g. a coastline file, or the
return value from \code{\link{mapLocator}}), in which case the following
two arguments are ignored.}

\item{latitude}{vector of latitudes of points, needed only if they cannot
be inferred from the first argument.}
}
\value{
A list containing \code{x} and \code{y}.
}
\description{
Find (x, y) values corresponding to (longitude, latitude) values, using the
present projection.
}
\details{
This is mainly a wrapper around \code{\link{lonlat2map}}.
}
\examples{
\dontrun{
library(oce)
data(coastlineWorld)
par(mfrow=c(2, 1), mar=rep(2, 4))
mapPlot(coastlineWorld, projection="+proj=moll") # sets a projection
xy <- mapLongitudeLatitudeXY(coastlineWorld)
plot(xy, type='l', asp=1)
}

}
\seealso{
A map must first have been created with \code{\link{mapPlot}}.

Other functions related to maps: \code{\link{lonlat2map}},
  \code{\link{lonlat2utm}}, \code{\link{map2lonlat}},
  \code{\link{mapArrows}}, \code{\link{mapAxis}},
  \code{\link{mapContour}},
  \code{\link{mapDirectionField}}, \code{\link{mapGrid}},
  \code{\link{mapImage}}, \code{\link{mapLines}},
  \code{\link{mapLocator}}, \code{\link{mapPlot}},
  \code{\link{mapPoints}}, \code{\link{mapPolygon}},
  \code{\link{mapScalebar}}, \code{\link{mapText}},
  \code{\link{mapTissot}}, \code{\link{oceCRS}},
  \code{\link{shiftLongitude}}, \code{\link{usrLonLat}},
  \code{\link{utm2lonlat}}
}
\author{
Dan Kelley
}
\concept{functions related to maps}
