% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.R
\docType{methods}
\name{subset,met-method}
\alias{subset,met-method}
\title{Subset a met Object}
\usage{
\S4method{subset}{met}(x, subset, ...)
}
\arguments{
\item{x}{An object inheriting from \code{\link{met-class}}.}

\item{subset}{An expression indicating how to subset \code{x}.}

\item{\dots}{ignored.}
}
\value{
A new \code{met} object.
}
\description{
This function is somewhat analogous to \code{\link{subset.data.frame}}.
}
\examples{
library(oce)
data(met)
# Few days surrounding Hurricane Juan
plot(subset(met, time > as.POSIXct("2003-09-27", tz="UTC")))

}
\seealso{
Other things related to \code{met} data: \code{\link{[[,met-method}},
  \code{\link{[[<-,met-method}}, \code{\link{as.met}},
  \code{\link{download.met}}, \code{\link{met-class}},
  \code{\link{met}}, \code{\link{plot,met-method}},
  \code{\link{read.met}}, \code{\link{summary,met-method}}

Other functions that subset \code{oce} objects: \code{\link{subset,adp-method}},
  \code{\link{subset,adv-method}},
  \code{\link{subset,amsr-method}},
  \code{\link{subset,argo-method}},
  \code{\link{subset,cm-method}},
  \code{\link{subset,coastline-method}},
  \code{\link{subset,ctd-method}},
  \code{\link{subset,echosounder-method}},
  \code{\link{subset,lobo-method}},
  \code{\link{subset,oce-method}},
  \code{\link{subset,odf-method}},
  \code{\link{subset,rsk-method}},
  \code{\link{subset,sealevel-method}},
  \code{\link{subset,section-method}},
  \code{\link{subset,topo-method}}
}
\author{
Dan Kelley
}
\concept{functions that subset \code{oce} objects}
\concept{things related to \code{met} data}
