% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\name{handleFlagsInternal}
\alias{handleFlagsInternal}
\title{Low-level function for handling data-quality flags}
\usage{
handleFlagsInternal(object, flags, actions, debug = 0)
}
\arguments{
\item{object}{An \code{oce} object, i.e. an object that inherits from \code{\link{oce-class}}.}

\item{flags}{A named \code{\link{list}} of numeric values, e.g. \code{list(good=1,bad=2)}.}

\item{actions}{A character vector indicating actions to be carried out for the corresponding
\code{flags} values. This will be lengthened with \code{\link{rep}} if necessary, to be
of the same length as \code{flags}. A common value for \code{actions} is \code{"NA"}, which
means that data values that are flagged are replaced by \code{NA} in the returned result.}

\item{debug}{An integer indicating the degree of debugging requested, with value \code{0}
meaning to act silently, and value \code{1} meaning to print some information about the
steps in processing.}
}
\value{
A copy of \code{object}, modified as indicated by \code{flags} and \code{actions}.
}
\description{
This function carries out low-level processing relating to data-quality flags,
as a support for higher-level functions such \code{\link{handleFlags,ctd-method}} for
\code{ctd} objects. In most cases, users will not call \code{handleFlagsInternal}
directly.
}
