% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{[[,adp-method}
\alias{[[,adp-method}
\title{Extract Something from an adp Object}
\usage{
\S4method{[[}{adp}(x, i, j, ...)
}
\arguments{
\item{x}{an \linkS4class{adp} object.}

\item{i}{Character string indicating the name of an item to extract.}

\item{j}{Optional additional information on the \code{i} item.}

\item{...}{Optional additional information (ignored).}
}
\description{
The \code{[[} method works for all \code{oce} objects, i.e.
objects inheriting from \linkS4class{oce}.  The purpose
is to insulate users from the internal details of \code{oce}
objects, by looking for items within the various storage
slots of the object. Items that are not actually stored in
the object can also be extracted, including derived data such
as potential temperature, the units of measurement for
the data, data-quality flags, etc.
}
\details{
A two-step process is used to try to find the
requested information. First, a class-specific function
tries to find it, but
if that fails, then a general function is used
(see next section).
}
\section{Details of the general method}{


If the specialized method produces no matches, the following generalized
method is applied. As with the specialized method, the procedure hinges
first on the values of \code{i} and, optionally, \code{j}. The work
proceeds in steps, by testing a sequence of possible conditions
in sequence.
\enumerate{
\item A check is made as to whether \code{i} names one of the standard
\code{oce} slots. If so, \code{[[} returns the slot contents of that slot.
Thus, \code{x[["metadata"]]} will retrieve the \code{metadata} slot,
while \code{x[["data"]]} and \code{x[["processingLog"]]} return
those slots.
\item If \code{i} is a string ending in the
\code{"Unit"}, then the characters preceding that string
are taken to be the name of an item in the data object, and a list
containing the unit is returned. This list consists of an item
named \code{unit}, which is an \code{\link[=expression]{expression()}}, and
an item named \code{scale}, which is a string describing the
measurement scale.  If the string ends in \code{" unit"}, e.g.
\code{x[["temperature unit"]]} (note the space),
then just the expression is returned, and if it ends in
\code{" scale"}, then just the scale is returned.
\item If \code{i} is a string ending in \code{"Flag"}, then the corresponding
data-quality flag is returned (or \code{NULL} if there is no such flag).
For example, \code{x[["salinityFlag"]]} returns a vector of salinity
flags if \code{x} is a ctd object.
\item If \code{i} is \code{"sigmaTheta"}, then the value of
\code{\link[=swSigmaTheta]{swSigmaTheta()}} is called with \code{x} as the sole
argument, and the results are returned. Similarly,
\code{\link[=swSigma0]{swSigma0()}} is used if \code{i="sigma0"}, and
\code{\link[=swSpice]{swSpice()}} is used if \code{i="spice"}. Of course, these
actions only make sense for objects that contain
the relevant items within their \code{data} slot.
\item After these possibilities are eliminated,
the action depends on whether \code{j} has been provided.
If \code{j} is not provided, or is the string \code{""},
then \code{i} is sought
in the \code{metadata} slot, and then in the \code{data} slot,
returning whichever is found first.  In other words, if \code{j}
is not provided, the \code{metadata} slot takes preference over
the \code{data} slot. However, if \code{j} is provided, then
it must be either the string \code{"metadata"} or \code{"data"},
and it directs where to look.
}

If none of the above-listed conditions holds, then \code{NULL} is returned,
without the issuance of a warning or error message. (This silent operation
is employed so that \code{[[} will behave like the normal R version.)
}

\section{Details of the specialized \code{adp} method}{


In addition to the usual extraction of elements by name, some shortcuts
are also provided, e.g. \code{x[["u1"]]} retrieves \code{v[,1]}, and similarly
for the other velocity components. The \code{a} and \code{q}
data can be retrieved in \code{\link[=raw]{raw()}} form or numeric
form (see examples). The coordinate system may be
retrieved with e.g. \code{x[["coordinate"]]}.
}

\examples{
data(adp)
# Tests for beam 1, distance bin 1, first 5 observation times
adp[["v"]][1:5,1,1]
adp[["a"]][1:5,1,1]
adp[["a", "numeric"]][1:5,1,1]
as.numeric(adp[["a"]][1:5,1,1]) # same as above

}
\seealso{
Other functions that extract parts of oce objects: 
\code{\link{[[,adv-method}},
\code{\link{[[,amsr-method}},
\code{\link{[[,argo-method}},
\code{\link{[[,bremen-method}},
\code{\link{[[,cm-method}},
\code{\link{[[,coastline-method}},
\code{\link{[[,ctd-method}},
\code{\link{[[,echosounder-method}},
\code{\link{[[,g1sst-method}},
\code{\link{[[,gps-method}},
\code{\link{[[,ladp-method}},
\code{\link{[[,landsat-method}},
\code{\link{[[,lisst-method}},
\code{\link{[[,lobo-method}},
\code{\link{[[,met-method}},
\code{\link{[[,oce-method}},
\code{\link{[[,odf-method}},
\code{\link{[[,rsk-method}},
\code{\link{[[,sealevel-method}},
\code{\link{[[,section-method}},
\code{\link{[[,tidem-method}},
\code{\link{[[,topo-method}},
\code{\link{[[,windrose-method}},
\code{\link{[[,xbt-method}},
\code{\link{[[<-,adv-method}}

Other things related to adp data: 
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp-class}},
\code{\link{adpEnsembleAverage}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamToXyz}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnuAdp}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}
}
\author{
Dan Kelley
}
\concept{functions that extract parts of oce objects}
\concept{things related to adp data}
