% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm.R
\name{as.cm}
\alias{as.cm}
\title{Coerce data into a CM object}
\usage{
as.cm(
  time,
  u = NULL,
  v = NULL,
  pressure = NULL,
  conductivity = NULL,
  temperature = NULL,
  salinity = NULL,
  longitude = NA,
  latitude = NA,
  filename = "",
  debug = getOption("oceDebug")
)
}
\arguments{
\item{time}{A vector of times of observation, or an \code{oce} object from which time
and two velocity components can be inferred, e.g. an \linkS4class{adv} object, or
an \linkS4class{adp} object that has only one distance bin.  If \code{time} is an \code{oce} object,
then all of the following arguments are ignored.}

\item{u, v}{optional numerical vectors containing the x and y components of velocity (m/s).}

\item{pressure, conductivity, salinity, temperature}{optional numerical vectors
containing pressure (dbar), electrical conductivity, practical salinity,
and in-situ temperature (degree C).}

\item{longitude, latitude}{optional position specified in degrees East and North.}

\item{filename}{optional source file name.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\description{
Coerce data into a CM object
}
\examples{
library(oce)
# Example 1: creation from scratch
t <- Sys.time() + 0:50
u <- sin(2*pi*0:50/5) + rnorm(51)
v <- cos(2*pi*0:50/5) + rnorm(51)
p <- 100 + rnorm(51)
summary(as.cm(t, u, v, p))

# Example 2: creation from an adv object
data(adv)
summary(as.cm(adv))

}
\seealso{
Other things related to cm data: 
\code{\link{[[,cm-method}},
\code{\link{[[<-,cm-method}},
\code{\link{cm-class}},
\code{\link{cm}},
\code{\link{plot,cm-method}},
\code{\link{read.cm}()},
\code{\link{rotateAboutZ}()},
\code{\link{subset,cm-method}},
\code{\link{summary,cm-method}}
}
\concept{things related to cm data}
