% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swSstar}
\alias{swSstar}
\title{Seawater Preformed Salinity, in GSW formulation}
\usage{
swSstar(salinity, pressure = NULL, longitude = NULL, latitude = NULL)
}
\arguments{
\item{salinity}{either practical salinity (in which case
\code{pressure} must be provided) \emph{or} an \code{oce} object with
\code{salinity} and \code{pressure} in its data slot, and with
\code{longitude} and \code{latitude} either there, or in the metadata
slot.}

\item{pressure}{pressure in dbar.}

\item{longitude}{longitude of observation.}

\item{latitude}{latitude of observation.}
}
\value{
Preformed Salinity, S*, in \eqn{g/kg}{g/kg}.
}
\description{
Compute seawater Preformed Salinity (S*), according to the GSW/TEOS-10
formulation with \code{\link[gsw:gsw_Sstar_from_SA]{gsw::gsw_Sstar_from_SA()}} in the \CRANpkg{gsw} package.
}
\examples{
\dontrun{
sa <- swAbsoluteSalinity(35.5, 300, 260, 16)
stopifnot(abs(35.671358392019094 - sa) < 00.000000000000010)
}

}
\references{
McDougall, T.J. and P.M. Barker, 2011: Getting started with
TEOS-10 and the Gibbs Seawater (GSW) Oceanographic Toolbox, 28pp.,
SCOR/IAPSO WG127, ISBN 978-0-646-55621-5.
}
\seealso{
For some objects, S-star may also be recovered by
indexing as e.g. \code{ctd[["Sstar"]]}.

Other functions that calculate seawater properties: 
\code{\link{T68fromT90}()},
\code{\link{T90fromT48}()},
\code{\link{T90fromT68}()},
\code{\link{computableWaterProperties}()},
\code{\link{locationForGsw}()},
\code{\link{swAbsoluteSalinity}()},
\code{\link{swAlphaOverBeta}()},
\code{\link{swAlpha}()},
\code{\link{swBeta}()},
\code{\link{swCSTp}()},
\code{\link{swConservativeTemperature}()},
\code{\link{swDepth}()},
\code{\link{swDynamicHeight}()},
\code{\link{swLapseRate}()},
\code{\link{swN2}()},
\code{\link{swPressure}()},
\code{\link{swRho}()},
\code{\link{swRrho}()},
\code{\link{swSCTp}()},
\code{\link{swSR}()},
\code{\link{swSTrho}()},
\code{\link{swSigma0}()},
\code{\link{swSigma1}()},
\code{\link{swSigma2}()},
\code{\link{swSigma3}()},
\code{\link{swSigma4}()},
\code{\link{swSigmaTheta}()},
\code{\link{swSigmaT}()},
\code{\link{swSigma}()},
\code{\link{swSoundAbsorption}()},
\code{\link{swSoundSpeed}()},
\code{\link{swSpecificHeat}()},
\code{\link{swSpice}()},
\code{\link{swTFreeze}()},
\code{\link{swTSrho}()},
\code{\link{swThermalConductivity}()},
\code{\link{swTheta}()},
\code{\link{swViscosity}()},
\code{\link{swZ}()}
}
\author{
Dan Kelley
}
\concept{functions that calculate seawater properties}
