% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.R
\name{binCount1D}
\alias{binCount1D}
\title{Bin-count Vector Data}
\usage{
binCount1D(x, xbreaks, include.lowest = FALSE)
}
\arguments{
\item{x}{vector of numerical values.}

\item{xbreaks}{Vector of values of x at the boundaries between bins, calculated using
\code{\link[=pretty]{pretty()}} if not supplied.}

\item{include.lowest}{logical value indicating whether to include
\code{x} values that equal \code{xbreaks[1]}.  See \dQuote{Details}.}
}
\value{
A list with the following elements: the breaks (\code{xbreaks},
midpoints (\code{xmids}) between those breaks, and
the count (\code{number}) of \code{x} values between successive breaks.
}
\description{
Count the number of elements of a given vector that fall within
successive pairs of values within a second vector.
}
\details{
By default, the sub-intervals defined by the \code{xbreaks} argument are open
on the left and closed on the right, to match the behaviour
of \code{\link[=cut]{cut()}}.  An open interval does not include points on
the boundary, and so any \code{x} values that exactly match
the first \code{breaks} value will not be counted.  To count such
points, set \code{include.lowest} to TRUE.

To contextualize \code{binCount1D()} in terms of base R functions,
note that

\if{html}{\out{<div class="sourceCode">}}\preformatted{binCount1D(1:20, seq(0, 20, 2))$number
}\if{html}{\out{</div>}}

matches

\if{html}{\out{<div class="sourceCode">}}\preformatted{unname(table(cut(1:20, seq(0, 20, 2))))
}\if{html}{\out{</div>}}
}
\seealso{
Other bin-related functions: 
\code{\link{binApply1D}()},
\code{\link{binApply2D}()},
\code{\link{binAverage}()},
\code{\link{binCount2D}()},
\code{\link{binMean1D}()},
\code{\link{binMean2D}()}
}
\author{
Dan Kelley
}
\concept{bin-related functions}
