library(oce)
test_that("all read() functions give similar errors for missing files",
    {
        msg <- "cannot find file \"no such file\""
        expect_error(read.adp("no such file"), msg)
        expect_error(read.adp.ad2cp("no such file"), msg)
        expect_error(read.adp.rdi("no such file"), msg)
        expect_error(read.adp.nortek("no such file"), msg)
        expect_error(read.adp.sontek("no such file"), msg)
        expect_error(read.adp.sontek.serial("no such file"), msg)
        expect_error(read.adv("no such file"), msg)
        expect_error(read.adv.nortek("no such file"), msg)
        expect_error(read.adv.sontek.serial("no such file"), msg)
        expect_error(read.adv.sontek.adr("no such file"), msg)
        expect_error(read.adv.sontek.text("no such file"), msg)
        expect_error(read.amsr("no such file"), msg)
        expect_error(read.aquadopp("no such file"), msg)
        expect_error(read.aquadoppProfiler("no such file"), msg)
        expect_error(read.aquadoppHR("no such file"), msg)
        expect_error(read.argo("no such file"), msg)
        expect_error(read.argo.copernicus("no such file"), msg)
        expect_error(read.bremen("no such file"), msg)
        expect_error(read.cm("no such file"), msg)
        expect_error(read.coastline("no such file"), msg)
        expect_error(read.coastline.shapefile("no such file"), msg)
        expect_error(read.coastline.openstreetmap("no such file"), msg)
        expect_error(read.ctd("no such file"), msg)
        expect_error(read.ctd.aml("no such file"), msg)
        expect_error(read.ctd.sbe("no such file"), msg)
        expect_error(read.ctd.ssda("no such file"), msg)
        expect_error(read.ctd.woce("no such file"), msg)
        expect_error(read.ctd.woce.other("no such file"), msg)
        expect_error(read.ctd.odf("no such file"), msg)
        expect_error(read.ctd.odv("no such file"), msg)
        expect_error(read.ctd.itp("no such file"), msg)
        expect_error(read.echosounder("no such file"), msg)
        expect_error(read.g1sst("no such file"), msg)
        expect_error(read.gps("no such file"), msg)
        expect_error(read.index("no such file"), msg)
        expect_error(read.landsat("no such file"), msg)
        expect_error(read.lisst("no such file"), msg)
        expect_error(read.lobo("no such file"), msg)
        expect_error(read.met("no such file"), msg)
        expect_error(read.topo("no such file"), msg)
        expect_error(read.netcdf("no such file"), msg)
        expect_error(read.oce("no such file"), msg)
        expect_error(read.odf("no such file"), msg)
        expect_error(read.rsk("no such file"), msg)
        expect_error(read.sealevel("no such file"), msg)
        expect_error(read.section("no such file"), msg)
        expect_error(read.woa("no such file"), msg)
        expect_error(read.xbt("no such file"), msg)
        expect_error(read.xbt.edf("no such file"), msg)
        expect_error(read.xbt.noaa1("no such file"), msg)
    })

test_that("all read() functions give similar errors for empty files",
    {
        msg <- "empty file"
        tempFile <- tempfile()
        file.create(tempFile)
        expect_error(read.adp(tempFile), msg)
        expect_error(read.adp.ad2cp(tempFile), msg)
        expect_error(read.adp.rdi(tempFile), msg)
        expect_error(read.adp.nortek(tempFile), msg)
        expect_error(read.adp.sontek(tempFile), msg)
        expect_error(read.adp.sontek.serial(tempFile), msg)
        expect_error(read.adv(tempFile), msg)
        expect_error(read.adv.nortek(tempFile), msg)
        expect_error(read.adv.sontek.serial(tempFile), msg)
        expect_error(read.adv.sontek.adr(tempFile), msg)
        expect_error(read.adv.sontek.text(tempFile), msg)
        expect_error(read.amsr(tempFile), msg)
        expect_error(read.aquadopp(tempFile), msg)
        expect_error(read.aquadoppProfiler(tempFile), msg)
        expect_error(read.aquadoppHR(tempFile), msg)
        expect_error(read.argo(tempFile), msg)
        expect_error(read.argo.copernicus(tempFile), msg)
        expect_error(read.bremen(tempFile), msg)
        expect_error(read.cm(tempFile), msg)
        expect_error(read.coastline(tempFile), msg)
        expect_error(read.coastline.shapefile(tempFile), msg)
        expect_error(read.coastline.openstreetmap(tempFile), msg)
        expect_error(read.ctd(tempFile), msg)
        expect_error(read.ctd.aml(tempFile), msg)
        expect_error(read.ctd.sbe(tempFile), msg)
        expect_error(read.ctd.ssda(tempFile), msg)
        expect_error(read.ctd.woce(tempFile), msg)
        expect_error(read.ctd.woce.other(tempFile), msg)
        expect_error(read.ctd.odf(tempFile), msg)
        expect_error(read.ctd.odv(tempFile), msg)
        expect_error(read.ctd.itp(tempFile), msg)
        expect_error(read.echosounder(tempFile), msg)
        expect_error(read.g1sst(tempFile), msg)
        expect_error(read.gps(tempFile), msg)
        expect_error(read.index(tempFile), msg)
        expect_error(read.landsat(tempFile), msg)
        expect_error(read.lisst(tempFile), msg)
        expect_error(read.lobo(tempFile), msg)
        expect_error(read.met(tempFile), msg)
        expect_error(read.topo(tempFile), msg)
        expect_error(read.netcdf(tempFile), msg)
        expect_error(read.oce(tempFile), msg)
        expect_error(read.odf(tempFile), msg)
        expect_error(read.rsk(tempFile), msg)
        expect_error(read.sealevel(tempFile), msg)
        expect_error(read.section(tempFile), msg)
        expect_error(read.woa(tempFile), msg)
        expect_error(read.xbt(tempFile), msg)
        expect_error(read.xbt.edf(tempFile), msg)
        expect_error(read.xbt.noaa1(tempFile), msg)
        file.remove(tempFile)
    })
