% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxph2WR.R
\name{coxph2WR}
\alias{coxph2WR}
\title{Take coxph object and translate results to win ratios.}
\usage{
coxph2WR(coutput, conf.level = 0.95)
}
\arguments{
\item{coutput}{a coxph object created by \code{\link[survival]{coxph}}.}

\item{conf.level}{confidence level.}
}
\value{
A vector or matrix with 4 elements (or columns) giving the win ratio,
the lower and upper confidence limits, and the two-sided p-value.
}
\description{
Let \code{cout} a coxph object, then Using normal approximations and the output from the
\code{cout$coefficients} and \code{cout$var}. If the cluster argument is used in the coxph
call, then \code{cout$var} is the robust variance (see \code{\link[survival]{coxph}}.
}
\details{
The function takes a beta coefficient and returns the win ratio version: exp(-beta).
Confidence intervals are calculated by
exp(-beta -/+ qnorm(1-(1-conf.level)/2)*sqrt(coutput$var)).
P-values are two-sided.
}
\examples{
data(simScenario5)
xform<-oceFormat(data=simScenario5,oceTime=c("T1","T2","T3"),
   oceStatus=c("I1","I2","I3"),
   group="Z",outputDataFrame=TRUE)
# perform cox regression using time varying treatment efects, IZ1,IZ2, IZ3
# associated with the 3 prioritized endpoints
cout<- coxph(Surv(START, STOP, status) ~ IZ1+IZ2+IZ3, data=xform$data)
coxph2WR(cout)
}
\references{
Follmann, D., Fay, M. P., Hamasaki, T., and Evans, S. (2020). Analysis of
ordered composite endpoints. Statistics in Medicine, 39(5), 602-616.
}
