% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver-redshift.R
\docType{class}
\name{redshift}
\alias{redshift}
\alias{RedshiftOdbcDriver-class}
\alias{dbConnect,RedshiftOdbcDriver-method}
\title{Helper for Connecting to Redshift via ODBC}
\usage{
redshift()

\S4method{dbConnect}{RedshiftOdbcDriver}(
  drv,
  clusterId,
  server,
  database,
  region = NULL,
  driver = NULL,
  uid = NULL,
  pwd = NULL,
  dbUser = uid,
  ...
)
}
\arguments{
\item{drv}{An object that inherits from \link[DBI:DBIDriver-class]{DBI::DBIDriver},
or an existing \link[DBI:DBIConnection-class]{DBI::DBIConnection}
object (in order to clone an existing connection).}

\item{clusterId}{The Redshift cluster identifier. Only one of \code{clusterId} or
the more verbose \code{server} is required.}

\item{server}{The full hostname of the Redshift cluster.}

\item{database}{The name of the Redshift database to connect to.}

\item{region}{The AWS region the Redshift cluster runs in. Ignored when
\code{server} is provided. Defaults to the value of the environment variable
\code{AWS_REGION}, then \code{AWS_REGION}, or uses \code{us-east-1} if both are unset.}

\item{driver}{The name of or path to a Redshift ODBC driver, or \code{NULL} to
locate one automatically.}

\item{uid, pwd}{Disable IAM credentials and manually specify a username and
password for authentication.}

\item{dbUser}{The Redshift database account.}

\item{...}{Further arguments passed on to \code{\link[=dbConnect]{dbConnect()}}.}
}
\value{
An \code{OdbcConnection} object with an active connection to a Redshift
cluster or SQL warehouse.
}
\description{
Connect to Redshift clusters via ODBC.

In particular, the custom \code{dbConnect()} method for Redshift ODBC drivers
automatically determines whether IAM-based credentials are available, much
like other AWS SDKs and tools. This requires the \pkg{paws.common} package.
}
\examples{
\dontrun{
# Connect to Redshift using IAM credentials.
DBI::dbConnect(
  odbc::redshift(),
  clusterId = "my-testing-cluster",
  database = "dev",
  dbUser = "me"
)
}
}
