% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{compute_features}
\alias{compute_features}
\title{Computes features for each network.}
\usage{
compute_features(gr, attributes = FALSE, attr_name = NULL, fast = FALSE)
}
\arguments{
\item{gr}{The network or graph as an \code{igraph} object.}

\item{attributes}{If the network nodes/vertices have attributes, then \code{attributes = TRUE}.}

\item{attr_name}{The name of the node/vertex attribute. Only a single attribute can
be specified.}

\item{fast}{If set to \code{TRUE} will avoid computing time consuming features.}
}
\value{
A network features object containing 20 graph-theoretic features.
}
\description{
This function computes features for each network using graph theoretic constructs.
}
\examples{
set.seed(1)
gr <- igraph::erdos.renyi.game(100, 0.05)
compute_features(gr)


}
