% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_things.R
\name{rmvnorm}
\alias{rmvnorm}
\title{Draw from multivariate normal distribution}
\usage{
rmvnorm(n = 1, mean, Sigma, log = FALSE)
}
\arguments{
\item{n}{An \code{integer}, the number of samples.}

\item{mean}{A \code{numeric}, the mean vector of length \code{p}.}

\item{Sigma}{A \code{matrix}, the covariance matrix of dimension \code{p} x \code{p}.}

\item{log}{A \code{logical}, if \code{TRUE} the draw is taken from the log-normal
distribution.
By default, \code{log = FALSE}.}
}
\value{
If \code{n = 1} a \code{vector} of length \code{p}, else
a \code{matrix} of dimension \code{n} times \code{p} with samples as rows.
}
\description{
This function draws from a multivariate normal distribution.
}
\examples{
mean <- c(0, 0)
Sigma <- diag(2)
rmvnorm(n = 3, mean = mean, Sigma = Sigma)
rmvnorm(mean = mean, Sigma = Sigma, log = TRUE)

}
