% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov_chain.R
\name{simulate_markov_chain}
\alias{simulate_markov_chain}
\title{Simulate Markov chain}
\usage{
simulate_markov_chain(Gamma, T, delta = stationary_distribution(Gamma))
}
\arguments{
\item{Gamma}{A transition probability \code{matrix}.}

\item{T}{An \code{integer}, the length of the Markov chain.}

\item{delta}{A \code{numeric} probability vector, the initial distribution.
If not specified, \code{delta} is set to the stationary distribution of
\code{Gamma}.}
}
\value{
A \code{numeric} vector of length \code{T} with states.
}
\description{
This function simulates a Markov chain.
}
\examples{
Gamma <- sample_transition_probability_matrix(dim = 3)
simulate_markov_chain(Gamma = Gamma, T = 10)

}
