% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/wishart.R
\name{dwishart_cpp}
\alias{dwishart_cpp}
\alias{rwishart_cpp}
\alias{dwishart}
\alias{rwishart}
\title{Wishart distribution}
\usage{
dwishart_cpp(x, df, scale, log = FALSE, inv = FALSE)

rwishart_cpp(df, scale, inv = FALSE)

dwishart(x, df, scale, log = FALSE, inv = FALSE)

rwishart(df, scale, inv = FALSE)
}
\arguments{
\item{x}{[\code{matrix()}]\cr
A covariance matrix of dimension \code{p}.}

\item{df}{[\code{integer()}]\cr
The degrees of freedom greater of equal \code{p}.}

\item{scale}{[\code{matrix()}]\cr
The scale covariance matrix of dimension \code{p}.}

\item{log}{[\code{logical(1)}]\cr
Return the logarithm of the density value?}

\item{inv}{[\code{logical(1)}]\cr
Use this inverse Wishart distribution?}
}
\value{
For \code{dwishart()}: The density value.

For \code{rwishart()}: A \code{matrix}, the random draw.
}
\description{
The function \code{dwishart()} computes the density of a Wishart distribution.

The function \code{rwishart()} samples from a Wishart distribution.

The functions with suffix \verb{_cpp} perform no input checks, hence are faster.
}
\examples{
x <- diag(2)
df <- 4
scale <- diag(2)

# compute density
dwishart(x = x, df = df, scale = scale)
dwishart(x = x, df = df, scale = scale, log = TRUE)
dwishart(x = x, df = df, scale = scale, inv = TRUE)

# sample
rwishart(df = df, scale = scale)
rwishart(df = df, scale = scale, inv = TRUE)
}
\seealso{
Other simulation helpers: 
\code{\link{Simulator}},
\code{\link{correlated_regressors}()},
\code{\link{ddirichlet_cpp}()},
\code{\link{dmvnorm_cpp}()},
\code{\link{dtnorm_cpp}()},
\code{\link{simulate_markov_chain}()}
}
\concept{simulation helpers}
\keyword{distribution}
