% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_with.R
\name{ph_with_text}
\alias{ph_with_text}
\title{add text into a new shape}
\usage{
ph_with_text(x, str, type = "title", index = 1)
}
\arguments{
\item{x}{a pptx device}

\item{str}{text to add}

\item{type}{placeholder type}

\item{index}{placeholder index (integer). This is to be used when a placeholder type
is not unique in the current slide, e.g. two placeholders with type 'body'.}
}
\description{
add text into a new shape in a slide.
}
\examples{
fileout <- tempfile(fileext = ".pptx")
doc <- read_pptx()
doc <- add_slide(doc, layout = "Title and Content", master = "Office Theme")
doc <- ph_with_text(x = doc, type = "title", str = "Un titre")
doc <- ph_with_text(x = doc, type = "ftr", str = "pied de page")
doc <- ph_with_text(x = doc, type = "dt", str = format(Sys.Date()))
doc <- ph_with_text(x = doc, type = "sldNum", str = "slide 1")

doc <- add_slide(doc, layout = "Title Slide", master = "Office Theme")
doc <- ph_with_text(x = doc, type = "subTitle", str = "Un sous titre")
doc <- ph_with_text(x = doc, type = "ctrTitle", str = "Un titre")

if( has_zip() )
  print(doc, target = fileout )
}
