% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_section.R
\name{body_end_section_continuous}
\alias{body_end_section_continuous}
\title{add continuous section}
\usage{
body_end_section_continuous(x)
}
\arguments{
\item{x}{an rdocx object}
}
\description{
Section break starts the new section on the same page. This
type of section break is often used to change the number of columns
without starting a new page.
}
\examples{
str1 <- "Lorem ipsum dolor sit amet, consectetur adipiscing elit."
str1 <- rep(str1, 5)
str1 <- paste(str1, collapse = " ")
str2 <- "Aenean venenatis varius elit et fermentum vivamus vehicula."
str2 <- rep(str2, 5)
str2 <- paste(str2, collapse = " ")

doc_1 <- read_docx()
doc_1 <- body_add_par(doc_1, value = "Default section", style = "heading 1")
doc_1 <- body_add_par(doc_1, value = str1, style = "Normal")
doc_1 <- body_add_par(doc_1, value = str2, style = "Normal")
doc_1 <- body_end_section_continuous(doc_1)

print(doc_1, target = tempfile(fileext = ".docx"))
}
\seealso{
Other functions for Word sections: 
\code{\link{body_end_block_section}()},
\code{\link{body_end_section_columns_landscape}()},
\code{\link{body_end_section_columns}()},
\code{\link{body_end_section_landscape}()},
\code{\link{body_end_section_portrait}()}
}
\concept{functions for Word sections}
