% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_docx.R
\name{set_doc_properties}
\alias{set_doc_properties}
\title{set document properties}
\usage{
set_doc_properties(x, title = NULL, subject = NULL, creator = NULL,
  description = NULL, created = NULL)
}
\arguments{
\item{x}{an rdocx or rpptx object}

\item{title, subject, creator, description}{text fields}

\item{created}{a date object}
}
\description{
set Word or PowerPoint document properties. These are not visible
in the document but are available as metadata of the document.
}
\note{
The "last modified" and "last modified by" fields will be automatically be updated
when the file is written.
}
\examples{
library(magrittr)
read_docx() \%>\% set_doc_properties(title = "title",
  subject = "document subject", creator = "Me me me",
  description = "this document is empty",
  created = Sys.time()) \%>\% doc_properties()
}
