% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_location.R
\name{ph_location_template}
\alias{ph_location_template}
\title{create a location for a placeholder based on a template}
\usage{
ph_location_template(left = 1, top = 1, width = 4, height = 3,
  newlabel = "", type = NULL, id = 1, ...)
}
\arguments{
\item{left, top, width, height}{place holder coordinates
in inches.}

\item{newlabel}{a label for the placeholder. See section details.}

\item{type}{placeholder type to look for in the slide layout, one
of 'body', 'title', 'ctrTitle', 'subTitle', 'dt', 'ftr', 'sldNum'.
It will be used as a template placeholder.}

\item{id}{index of the placeholder template. If two body placeholder, there can be
two different index: 1 and 2 for the first and second body placeholders defined
in the layout.}

\item{...}{unused arguments}
}
\description{
The function will return a list that complies with
expected format for argument \code{location} of function
\code{ph_with}. A placeholder will be used as template
and its positions will be updated with values \code{left}, \code{top}, \code{width}, \code{height}.
}
\details{
The location of the bounding box associated to a placeholder
within a slide is specified with the left top coordinate,
the width and the height. These are defined in inches:

\describe{
\item{left}{left coordinate of the bounding box}
\item{top}{top coordinate of the bounding box}
\item{width}{width of the bounding box}
\item{height}{height of the bounding box}
}

In addition to these attributes, a label can be
associated with the shape. Shapes, text boxes, images and other objects
will be identified with that label in the Selection Pane of PowerPoint.
This label can then be reused by other functions such as \code{ph_location_label()}.
It can be set with argument \code{newlabel}.
}
\examples{
doc <- read_pptx()
doc <- add_slide(doc)
doc <- ph_with(doc, "Title",
  location = ph_location_type(type = "title") )
doc <- ph_with(doc, "Hello world",
    location = ph_location_template(top = 4, type = "title") )
print(doc, target = tempfile(fileext = ".pptx") )
}
\seealso{
Other functions for placeholder location: \code{\link{ph_location_fullsize}},
  \code{\link{ph_location_label}},
  \code{\link{ph_location_left}},
  \code{\link{ph_location_right}},
  \code{\link{ph_location_type}}, \code{\link{ph_location}}
}
\concept{functions for placeholder location}
