% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_block_objects.R
\name{fpar}
\alias{fpar}
\alias{update.fpar}
\title{Formatted paragraph}
\usage{
fpar(..., fp_p = fp_par(), fp_t = fp_text_lite(), values = NULL)

\method{update}{fpar}(object, fp_p = NULL, fp_t = NULL, ...)
}
\arguments{
\item{...}{cot objects (\code{\link[=ftext]{ftext()}}, \code{\link[=external_img]{external_img()}})}

\item{fp_p}{paragraph formatting properties, see \code{\link[=fp_par]{fp_par()}}}

\item{fp_t}{default text formatting properties. This is used as
text formatting properties when simple text is provided as argument,
see \code{\link[=fp_text]{fp_text()}}.}

\item{values}{a list of cot objects. If provided, argument \code{...} will be ignored.}

\item{object}{fpar object}
}
\description{
Create a paragraph representation by concatenating
formatted text or images. The result can be inserted in a Word document
or a PowerPoint presentation and can also be inserted in a \code{\link[=block_list]{block_list()}}
call.

All its arguments will be concatenated to create a paragraph where chunks of
text and images are associated with formatting properties.

\code{fpar} supports \code{\link[=ftext]{ftext()}}, \code{\link[=external_img]{external_img()}}, \code{run_*} functions
(i.e. \code{\link[=run_autonum]{run_autonum()}}, \code{\link[=run_seqfield]{run_seqfield()}}) when output is Word, and simple strings.

Default text and paragraph formatting properties can also be modified
with function \code{update()}.
}
\examples{
fpar(ftext("hello", shortcuts$fp_bold()))

# mix text and image -----
img.file <- file.path( R.home("doc"), "html", "logo.jpg" )

bold_face <- shortcuts$fp_bold(font.size = 12)
bold_redface <- update(bold_face, color = "red")
fpar_1 <- fpar(
  "Hello World, ",
  ftext("how ", prop = bold_redface ),
  external_img(src = img.file, height = 1.06/2, width = 1.39/2),
  ftext(" you?", prop = bold_face ) )
fpar_1

img_in_par <- fpar(
  external_img(src = img.file, height = 1.06/2, width = 1.39/2),
  fp_p = fp_par(text.align = "center") )
}
\seealso{
\code{\link[=block_list]{block_list()}}, \code{\link[=body_add_fpar]{body_add_fpar()}}, \code{\link[=ph_with]{ph_with()}}

Other block functions for reporting: 
\code{\link{block_caption}()},
\code{\link{block_list}()},
\code{\link{block_pour_docx}()},
\code{\link{block_section}()},
\code{\link{block_table}()},
\code{\link{block_toc}()},
\code{\link{plot_instr}()},
\code{\link{unordered_list}()}
}
\concept{block functions for reporting}
